/*
 * Decompiled with CFR 0.152.
 */
package fr.jayasoft.ivy.util;

import fr.jayasoft.ivy.util.IvyPatternHelper;
import fr.jayasoft.ivy.util.StringUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class Configurator {
    private Map _typedefs = new HashMap();
    private Map _macrodefs = new HashMap();
    private Stack _objectStack = new Stack();
    private static final List TRUE_VALUES = Arrays.asList("true", "yes", "on");

    public void typeDef(String name, String className) throws ClassNotFoundException {
        this.typeDef(name, Class.forName(className));
    }

    public void typeDef(String name, Class clazz) {
        this._typedefs.put(name, clazz);
    }

    public void setRoot(Object root) {
        if (root == null) {
            throw new NullPointerException();
        }
        this._objectStack.clear();
        this.setCurrent(root, null);
    }

    public void clear() {
        this._objectStack.clear();
    }

    private void setCurrent(Object object, String name) {
        this._objectStack.push(new ObjectDescriptor(object, name));
    }

    public Object startCreateChild(String name) {
        if (this._objectStack.isEmpty()) {
            throw new IllegalStateException("set root before creating child");
        }
        ObjectDescriptor parentOD = (ObjectDescriptor)this._objectStack.peek();
        Object parent = parentOD.getObject();
        if (parent instanceof MacroDef && !"attribute".equals(name) && !"element".equals(name)) {
            MacroRecord record = ((MacroDef)parent).recordCreateChild(name);
            this.setCurrent(record, name);
            return record;
        }
        if (parent instanceof Macro) {
            MacroRecord record = ((Macro)parent).recordCreateChild(name);
            this.setCurrent(record, name);
            return record;
        }
        if (parent instanceof MacroRecord) {
            MacroRecord record = ((MacroRecord)parent).recordChild(name);
            this.setCurrent(record, name);
            return record;
        }
        Object child = null;
        MacroDef macrodef = (MacroDef)this._macrodefs.get(name);
        if (macrodef != null) {
            Macro macro = macrodef.createMacro();
            this.setCurrent(macro, name);
            return macro;
        }
        Class<?> childClass = (Class<?>)this._typedefs.get(name);
        Method addChild = null;
        try {
            if (childClass != null) {
                return this.addChild(parentOD, childClass, name, null);
            }
            addChild = parentOD.getCreateMethod(name);
            if (addChild != null) {
                child = addChild.invoke(parent, new Object[0]);
                this.setCurrent(child, name);
                return child;
            }
            addChild = parentOD.getAddMethod(name);
            if (addChild != null) {
                childClass = addChild.getParameterTypes()[0];
                child = childClass.newInstance();
                addChild.invoke(parent, child);
                this.setCurrent(child, name);
                return child;
            }
            addChild = parentOD.getAddConfiguredMethod(name);
            if (addChild != null) {
                childClass = addChild.getParameterTypes()[0];
                child = childClass.newInstance();
                this.setCurrent(child, name);
                return child;
            }
        }
        catch (InstantiationException ex) {
            throw new IllegalArgumentException("no default constructor on " + childClass + " for adding " + name + " on " + parent.getClass());
        }
        catch (Exception ex) {
            IllegalArgumentException iae = new IllegalArgumentException("bad method found for " + name + " on " + parent.getClass());
            iae.initCause(ex);
            throw iae;
        }
        throw new IllegalArgumentException("no appropriate method found for adding " + name + " on " + parent.getClass());
    }

    public void addChild(String name, Object child) {
        if (this._objectStack.isEmpty()) {
            throw new IllegalStateException("set root before creating child");
        }
        ObjectDescriptor parentOD = (ObjectDescriptor)this._objectStack.peek();
        try {
            this.addChild(parentOD, child.getClass(), name, child);
        }
        catch (InstantiationException ex) {
            throw new IllegalArgumentException("no default constructor on " + child.getClass() + " for adding " + name + " on " + parentOD.getObject().getClass());
        }
        catch (Exception ex) {
            IllegalArgumentException iae = new IllegalArgumentException("bad method found for " + name + " on " + parentOD.getObject().getClass());
            iae.initCause(ex);
            throw iae;
        }
    }

    private Object addChild(ObjectDescriptor parentOD, Class childClass, String name, Object child) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        Object parent = parentOD.getObject();
        Method addChild = parentOD.getAddMethod(childClass);
        if (addChild != null) {
            if (child == null) {
                child = childClass.newInstance();
            }
            addChild.invoke(parent, child);
            this.setCurrent(child, name);
            return child;
        }
        addChild = parentOD.getAddConfiguredMethod(childClass);
        if (addChild != null) {
            if (child == null) {
                child = childClass.newInstance();
            }
            this.setCurrent(child, name);
            return child;
        }
        throw new IllegalArgumentException("no appropriate method found for adding " + name + " on " + parent.getClass());
    }

    public void setAttribute(String attributeName, String value) {
        if (this._objectStack.isEmpty()) {
            throw new IllegalStateException("set root before setting attribute");
        }
        ObjectDescriptor od = (ObjectDescriptor)this._objectStack.peek();
        if (od.getObject() instanceof Macro) {
            ((Macro)od.getObject()).defineAttribute(attributeName, value);
            return;
        }
        if (od.getObject() instanceof MacroRecord) {
            ((MacroRecord)od.getObject()).recordAttribute(attributeName, value);
            return;
        }
        Method m = od.getSetMethod(attributeName);
        if (m == null) {
            throw new IllegalArgumentException("no set method found for " + attributeName + " on " + od.getObject().getClass());
        }
        Object convertedValue = null;
        Class<?> paramClass = m.getParameterTypes()[0];
        try {
            convertedValue = paramClass.equals(String.class) ? value : (paramClass.equals(Boolean.class) || paramClass.equals(Boolean.TYPE) ? Boolean.valueOf(TRUE_VALUES.contains(value)) : (paramClass.equals(Character.class) || paramClass.equals(Character.TYPE) ? new Character(value.length() > 0 ? value.charAt(0) : (char)' ') : (paramClass.equals(Short.class) || paramClass.equals(Short.TYPE) ? Short.valueOf(value) : (paramClass.equals(Integer.class) || paramClass.equals(Integer.TYPE) ? Integer.valueOf(value) : (paramClass.equals(Long.class) || paramClass.equals(Long.TYPE) ? Long.valueOf(value) : (paramClass.equals(Class.class) ? Class.forName(value) : paramClass.getConstructor(String.class).newInstance(value)))))));
        }
        catch (Exception ex) {
            IllegalArgumentException iae = new IllegalArgumentException("impossible to convert " + value + " to " + paramClass + " for setting " + attributeName + " on " + od.getObject().getClass());
            iae.initCause(ex);
            throw iae;
        }
        try {
            m.invoke(od.getObject(), convertedValue);
        }
        catch (Exception ex) {
            IllegalArgumentException iae = new IllegalArgumentException("impossible to set " + attributeName + " to " + convertedValue + " on " + od.getObject().getClass());
            iae.initCause(ex);
            throw iae;
        }
    }

    public void addText(String text) {
        if (this._objectStack.isEmpty()) {
            throw new IllegalStateException("set root before adding text");
        }
        ObjectDescriptor od = (ObjectDescriptor)this._objectStack.peek();
        try {
            od.getObject().getClass().getMethod("addText", String.class).invoke(od.getObject(), text);
        }
        catch (Exception ex) {
            IllegalArgumentException iae = new IllegalArgumentException("impossible to add text on " + od.getObject().getClass());
            iae.initCause(ex);
            throw iae;
        }
    }

    public Object endCreateChild() {
        if (this._objectStack.isEmpty()) {
            throw new IllegalStateException("set root before ending child");
        }
        ObjectDescriptor od = (ObjectDescriptor)this._objectStack.pop();
        if (this._objectStack.isEmpty()) {
            this._objectStack.push(od);
            throw new IllegalStateException("cannot end root");
        }
        if (od.getObject() instanceof Macro) {
            return ((Macro)od.getObject()).play(this);
        }
        ObjectDescriptor parentOD = (ObjectDescriptor)this._objectStack.peek();
        String name = od.getObjectName();
        Class childClass = (Class)this._typedefs.get(name);
        Method m = null;
        m = childClass != null ? parentOD.getAddConfiguredMethod(childClass) : parentOD.getAddConfiguredMethod(name);
        try {
            if (m != null) {
                m.invoke(parentOD.getObject(), od.getObject());
            }
            return od.getObject();
        }
        catch (Exception ex) {
            IllegalArgumentException iae = new IllegalArgumentException("impossible to add configured child for " + name + " on " + parentOD.getObject().getClass());
            iae.initCause(ex);
            throw iae;
        }
    }

    public Object getCurrent() {
        return this._objectStack.isEmpty() ? null : ((ObjectDescriptor)this._objectStack.peek()).getObject();
    }

    public int getDepth() {
        return this._objectStack.size();
    }

    public MacroDef startMacroDef(String macroName) {
        MacroDef macroDef = new MacroDef(macroName);
        this.setCurrent(macroDef, macroName);
        return macroDef;
    }

    public void addMacroAttribute(String attName, String attDefaultValue) {
        ((MacroDef)this.getCurrent()).addAttribute(attName, attDefaultValue);
    }

    public void addMacroElement(String elementName, boolean optional) {
        ((MacroDef)this.getCurrent()).addElement(elementName, optional);
    }

    public void endMacroDef() {
        this.addConfiguredMacrodef((MacroDef)this.getCurrent());
        this._objectStack.pop();
    }

    public void addConfiguredMacrodef(MacroDef macrodef) {
        this._macrodefs.put(macrodef.getName(), macrodef);
    }

    public Class getTypeDef(String name) {
        return (Class)this._typedefs.get(name);
    }

    private static class ObjectDescriptor {
        private Object _obj;
        private String _objName;
        private Map _createMethods = new HashMap();
        private Map _addMethods = new HashMap();
        private Map _addConfiguredMethods = new HashMap();
        private Map _setMethods = new HashMap();
        private Map _typeAddMethods = new HashMap();
        private Map _typeAddConfiguredMethods = new HashMap();

        public ObjectDescriptor(Object object, String objName) {
            this._obj = object;
            this._objName = objName;
            Method[] methods = object.getClass().getMethods();
            for (int i = 0; i < methods.length; ++i) {
                String name;
                Method m = methods[i];
                if (m.getName().startsWith("create") && m.getParameterTypes().length == 0 && !Void.TYPE.equals(m.getReturnType())) {
                    name = StringUtils.uncapitalize(m.getName().substring("create".length()));
                    if (name.length() == 0) continue;
                    this.addCreateMethod(name, m);
                    continue;
                }
                if (m.getName().startsWith("addConfigured") && m.getParameterTypes().length == 1 && Void.TYPE.equals(m.getReturnType())) {
                    name = StringUtils.uncapitalize(m.getName().substring("addConfigured".length()));
                    if (name.length() == 0) {
                        this.addAddConfiguredMethod(m);
                    }
                    this.addAddConfiguredMethod(name, m);
                    continue;
                }
                if (m.getName().startsWith("add") && !m.getName().startsWith("addConfigured") && m.getParameterTypes().length == 1 && Void.TYPE.equals(m.getReturnType())) {
                    name = StringUtils.uncapitalize(m.getName().substring("add".length()));
                    if (name.length() == 0) {
                        this.addAddMethod(m);
                    }
                    this.addAddMethod(name, m);
                    continue;
                }
                if (!m.getName().startsWith("set") || m.getParameterTypes().length != 1 || !Void.TYPE.equals(m.getReturnType()) || (name = StringUtils.uncapitalize(m.getName().substring("set".length()))).length() == 0) continue;
                this.addSetMethod(name, m);
            }
        }

        public void addCreateMethod(String name, Method m) {
            this._createMethods.put(name, m);
        }

        public void addAddMethod(String name, Method m) {
            this._addMethods.put(name, m);
        }

        public void addAddConfiguredMethod(String name, Method m) {
            this._addConfiguredMethods.put(name, m);
        }

        private void addAddMethod(Method m) {
            this._typeAddMethods.put(m.getParameterTypes()[0], m);
        }

        private void addAddConfiguredMethod(Method m) {
            this._typeAddConfiguredMethods.put(m.getParameterTypes()[0], m);
        }

        public void addSetMethod(String name, Method m) {
            this._setMethods.put(name, m);
        }

        public Object getObject() {
            return this._obj;
        }

        public Method getCreateMethod(String name) {
            return (Method)this._createMethods.get(name);
        }

        public Method getAddMethod(String name) {
            return (Method)this._addMethods.get(name);
        }

        public Method getAddConfiguredMethod(String name) {
            return (Method)this._addConfiguredMethods.get(name);
        }

        public Method getAddMethod(Class type) {
            return this.getTypeMatchingMethod(type, this._typeAddMethods);
        }

        public Method getAddConfiguredMethod(Class type) {
            return this.getTypeMatchingMethod(type, this._typeAddConfiguredMethods);
        }

        private Method getTypeMatchingMethod(Class type, Map typeMethods) {
            Method m = (Method)typeMethods.get(type);
            if (m != null) {
                return m;
            }
            Iterator iter = typeMethods.keySet().iterator();
            while (iter.hasNext()) {
                Class clss = (Class)iter.next();
                if (!clss.isAssignableFrom(type)) continue;
                return (Method)typeMethods.get(clss);
            }
            return null;
        }

        public Method getSetMethod(String name) {
            return (Method)this._setMethods.get(name);
        }

        public String getObjectName() {
            return this._objName;
        }
    }

    public static class MacroDef {
        private String _name;
        private Map _attributes = new HashMap();
        private Map _elements = new HashMap();
        private MacroRecord _macroRecord;

        public MacroDef(String macroName) {
            this._name = macroName;
        }

        public Attribute getAttribute(String attributeName) {
            return (Attribute)this._attributes.get(attributeName);
        }

        public Object play(Configurator conf, Map attValues, Map macroRecords) {
            Iterator iter = this._attributes.values().iterator();
            while (iter.hasNext()) {
                Attribute att = (Attribute)iter.next();
                String val = (String)attValues.get(att.getName());
                if (val != null) continue;
                if (att.getDefault() == null) {
                    throw new IllegalArgumentException("attribute " + att.getName() + " is required in " + this.getName());
                }
                attValues.put(att.getName(), att.getDefault());
            }
            return this.play(conf, this._macroRecord, attValues, macroRecords);
        }

        private Object play(Configurator conf, MacroRecord macroRecord, Map attValues, Map childrenRecords) {
            conf.startCreateChild(macroRecord.getName());
            Map attributes = macroRecord.getAttributes();
            Iterator<Object> iter = attributes.keySet().iterator();
            while (iter.hasNext()) {
                String attName = (String)iter.next();
                String attValue = this.replaceParam((String)attributes.get(attName), attValues);
                conf.setAttribute(attName, attValue);
            }
            iter = macroRecord.getChildren().iterator();
            while (iter.hasNext()) {
                MacroRecord child = (MacroRecord)iter.next();
                Element elt = (Element)this._elements.get(child.getName());
                if (elt != null) {
                    List elements = (List)childrenRecords.get(child.getName());
                    if (elements != null) {
                        Iterator iterator = elements.iterator();
                        while (iterator.hasNext()) {
                            MacroRecord element = (MacroRecord)iterator.next();
                            Iterator it2 = element.getChildren().iterator();
                            while (it2.hasNext()) {
                                MacroRecord r = (MacroRecord)it2.next();
                                this.play(conf, r, attValues, Collections.EMPTY_MAP);
                            }
                        }
                        continue;
                    }
                    if (elt.isOptional()) continue;
                    throw new IllegalArgumentException("non optional element is not specified: " + elt.getName() + " in macro " + this.getName());
                }
                this.play(conf, child, attValues, childrenRecords);
            }
            return conf.endCreateChild();
        }

        private String replaceParam(String string, Map attValues) {
            return IvyPatternHelper.substituteParams(string, attValues);
        }

        public String getName() {
            return this._name;
        }

        public void addConfiguredAttribute(Attribute att) {
            this._attributes.put(att.getName(), att);
        }

        public void addConfiguredElement(Element elt) {
            this._elements.put(elt.getName(), elt);
        }

        public Macro createMacro() {
            return new Macro(this);
        }

        public void addAttribute(String attName, String attDefaultValue) {
            Attribute att = new Attribute();
            att.setName(attName);
            att.setDefault(attDefaultValue);
            this.addConfiguredAttribute(att);
        }

        public void addElement(String elementName, boolean optional) {
            Element elt = new Element();
            elt.setName(elementName);
            elt.setOptional(optional);
            this.addConfiguredElement(elt);
        }

        public MacroRecord recordCreateChild(String name) {
            this._macroRecord = new MacroRecord(name);
            return this._macroRecord;
        }
    }

    public static class MacroRecord {
        private String _name;
        private Map _attributes = new LinkedHashMap();
        private List _children = new ArrayList();

        public MacroRecord(String name) {
            this._name = name;
        }

        public String getName() {
            return this._name;
        }

        public void recordAttribute(String name, String value) {
            this._attributes.put(name, value);
        }

        public MacroRecord recordChild(String name) {
            MacroRecord child = new MacroRecord(name);
            this._children.add(child);
            return child;
        }

        public Map getAttributes() {
            return this._attributes;
        }

        public List getChildren() {
            return this._children;
        }
    }

    public static class Element {
        private String _name;
        private boolean _optional = false;

        public String getName() {
            return this._name;
        }

        public void setName(String name) {
            this._name = name;
        }

        public boolean isOptional() {
            return this._optional;
        }

        public void setOptional(boolean optional) {
            this._optional = optional;
        }
    }

    public static class Attribute {
        private String _name;
        private String _default;

        public String getDefault() {
            return this._default;
        }

        public void setDefault(String default1) {
            this._default = default1;
        }

        public String getName() {
            return this._name;
        }

        public void setName(String name) {
            this._name = name;
        }
    }

    public static class Macro {
        private MacroDef _macrodef;
        private Map _attValues = new HashMap();
        private Map _macroRecords = new HashMap();

        public Macro(MacroDef def) {
            this._macrodef = def;
        }

        public void defineAttribute(String attributeName, String value) {
            if (this._macrodef.getAttribute(attributeName) == null) {
                throw new IllegalArgumentException("undecalred attribute " + attributeName + " on macro " + this._macrodef.getName());
            }
            this._attValues.put(attributeName, value);
        }

        public MacroRecord recordCreateChild(String name) {
            MacroRecord macroRecord = new MacroRecord(name);
            ArrayList<MacroRecord> records = (ArrayList<MacroRecord>)this._macroRecords.get(name);
            if (records == null) {
                records = new ArrayList<MacroRecord>();
                this._macroRecords.put(name, records);
            }
            records.add(macroRecord);
            return macroRecord;
        }

        public Object play(Configurator conf) {
            return this._macrodef.play(conf, this._attValues, this._macroRecords);
        }
    }
}

